﻿using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using Microsoft.Web.Http;


namespace PpmsDataWebService.Controllers
{
    //[Authorize]
    [EnableQuery]    
    [ApiVersion("1.0")]
    public class AgreementProvidersController : ODataController
    {
        [ODataRoute("AgreementProviders({Name})")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string Name)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {                
                //Retrieve the Agreement Provider 
                var ppmsAgreementProvider = context.ppms_agreementproviderSet.FirstOrDefault(i => i.ppms_name.Equals(Name));
                if (ppmsAgreementProvider != null)
                {
                    var ppmsAgreementProvidersList = new List<ppms_agreementprovider> { ppmsAgreementProvider };
                    var agreementProviders = await AgreementProvidersMap.MapAgreementProviders(ppmsAgreementProvidersList, queryType, context);
                    return Request.CreateResponse(agreementProviders);
                }
            }
            var message = string.Format("Agreement Provider with Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("AgreementProviders({Name})/ProviderAgreement")]
        public async Task<HttpResponseMessage> GetProviderAgreements([FromODataUri] string Name)
        {

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Agreement Provider 
                var ppmsAgreementProvider = context.ppms_agreementproviderSet.FirstOrDefault(i => i.ppms_name.Equals(Name));
                if (ppmsAgreementProvider != null)
                {
                    //Return the related Provider Agreements
                    var ppmsProviderAgreement =
                        context.ppms_provideragreementSet.FirstOrDefault(i => i.Id == ppmsAgreementProvider.ppms_ProviderAgreement.Id);
                    var ppmsProviderAgreementList = new List<ppms_provideragreement> { ppmsProviderAgreement };
                    var providerAgreement =
                        await ProviderAgreementsMap.MapProviderAgreements(ppmsProviderAgreementList, "None", context);
                    return Request.CreateResponse(providerAgreement);
                }
            }
            var message = string.Format("Provider Agreement(s) with Agreement Provider name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("AgreementProviders({Name})/ProviderGroup")]
        public async Task<HttpResponseMessage> GetProviderGroup([FromODataUri] string Name)
        {

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Agreement Provider 
                var ppmsAgreementProvider = context.ppms_agreementproviderSet.FirstOrDefault(i => i.ppms_name.Equals(Name));
                if (ppmsAgreementProvider != null)
                {
                    //Return the related Provider Group
                    var ppmsProviderGroup =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsAgreementProvider.ppms_ProviderGroup.Id);
                    var ppmsProviderGroupList = new List<Account> { ppmsProviderGroup };
                    var providerGroup =
                        await ProviderMap.MapProviders(ppmsProviderGroupList, "None");
                    return Request.CreateResponse(providerGroup);
                }
            }
            var message = string.Format("Provider Group(s) with Agreement Provider name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("AgreementProviders({Name})/ExternalProvider")]
        public async Task<HttpResponseMessage> GetExternalProvider([FromODataUri] string Name)
        {
            
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Agreement Provider 
                var ppmsAgreementProvider = context.ppms_agreementproviderSet.FirstOrDefault(i => i.ppms_name.Equals(Name));
                if (ppmsAgreementProvider != null)
                {
                    //Return the related External Provider
                    var ppmsExternalProvider =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsAgreementProvider.ppms_ExternalProvider.Id);
                    var ppmsExternalProviderList = new List<Account> { ppmsExternalProvider };
                    var externalProvider =
                        await ProviderMap.MapProviders(ppmsExternalProviderList, "None");
                    return Request.CreateResponse(externalProvider);
                }
            }
            var message = string.Format("External Provider(s) with Agreement Provider name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("AgreementProviders")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Agreement Providers in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsAgreementProviders = context.ppms_agreementproviderSet.Where(i => i.ppms_name != null).Take(10);
                var ppmsAgreementProvidersList = ppmsAgreementProviders.ToList();
                if (ppmsAgreementProvidersList.Any())
                {
                    //Map Agreement Providers
                    var agreementProviders = await AgreementProvidersMap.MapAgreementProviders(ppmsAgreementProvidersList, "None", context);
                    return Request.CreateResponse(agreementProviders);
                }
                var message = string.Format("No Agreement Providers found");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }
        

    }
}